#ifndef _DKRAddOnTypes_
#define _DKRAddOnTypes_

/*
*	Listers inherit from DRKLister
*/
class DRKLister: public BObject
{
public:
	DRKLister(BResourceFile* resFile)	
			{fResFile = resFile;};
	
virtual void	Activate() = 0;
virtual void	Close() = 0;
virtual bool	CloseRequested() = 0;

protected:
	BResourceFile	*fResFile;
};

/*
*	Editors inherit from DRKEditor
*/
class DRKEditor : public BObject
{
public:
	DRKEditor(BResourceFile* resFile, long id)
			{fResFile = resFile; fID = id;};

virtual void	Activate() = 0;
virtual	bool	Modified() = 0;
virtual	void	Save() = 0;
virtual void	Close() = 0;
virtual bool	CloseRequested() = 0;
		
virtual	void	NotifyInfoChange()
						{};
protected:
	long			fID;
	BResourceFile	*fResFile;
};


#endif // _DKRAddOnTypes_